/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.sea;

import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextField;
import org.cesar.inmotion.sea.Attack;
import org.cesar.inmotion.sea.Constants;
import org.cesar.inmotion.sea.GameController;
import org.cesar.inmotion.sea.SeaPersistence;
import org.cesar.inmotion.sea.basic.Diver;
import org.cesar.inmotion.sea.basic.Fire;
import org.cesar.inmotion.sea.basic.Fish;
import org.cesar.inmotion.util.AbstractMIDlet;
import org.cesar.inmotion.util.ApplicationController;

public class GameCanvas
extends Canvas
implements CommandListener {
    private boolean isPaused;
    private boolean drawHiScore;
    private static GameCanvas instance;
    private boolean isGameOver;
    private Diver player;
    public static Attack attack;
    public static int frame;
    public static int ScreenHeight;
    public static int ScreenWidth;
    public static int SurfaceY;
    public static byte wave_index;
    public static int clouds_x;
    public static int clouds_y;
    public static byte level;

    public GameCanvas() {
        instance = this;
        Constants.lives = (byte)5;
        ScreenHeight = this.getHeight();
        ScreenWidth = this.getWidth();
        SurfaceY = ScreenHeight * 30 / 100;
        this.player = new Diver(Constants.img_diver[0][1]);
    }

    private void cleanAll(Graphics graphics) {
        graphics.setColor(0, 210, 255);
        graphics.fillRect(0, 0, graphics.getClipWidth(), graphics.getClipHeight());
    }

    public void init() {
        this.isPaused = false;
        this.isGameOver = false;
        this.removeCommand(Constants.pauseCommand);
        this.removeCommand(Constants.exitCommand);
        this.removeCommand(Constants.startCommand);
        this.addCommand(Constants.pauseCommand);
        this.addCommand(Constants.exitCommand);
        this.setCommandListener(this);
        this.player.init();
        attack = new Attack();
    }

    public void update() {
        ++frame;
        this.player.update();
        if (!attack.isActive()) {
            attack.init();
        } else {
            if (Constants.score > 2500 && level == 4) {
                level = (byte)(level + 1);
                attack.setLevel(level);
            } else if (Constants.score > 1500 && level == 3) {
                level = (byte)(level + 1);
                attack.setLevel(level);
            } else if (Constants.score > 1000 && level == 2) {
                level = (byte)(level + 1);
                attack.setLevel(level);
            } else if (Constants.score > 100 && level == 1) {
                level = (byte)(level + 1);
                attack.setLevel(level);
            }
            attack.update();
        }
        if (this.player.getFire() != null && this.player.getFire().isVisible()) {
            this.player.getFire().update();
        }
    }

    public void paint(Graphics graphics) {
        if (!this.isGameOver) {
            this.cleanAll(graphics);
            this.drawBackground(graphics);
            this.drawAttack(graphics);
            this.drawSub(graphics);
            this.drawFires(graphics);
            this.drawDetails(graphics);
        } else if (this.drawHiScore) {
            this.drawHiScore();
        } else {
            this.drawGameover(graphics);
        }
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                if (this.player.repeatRight) {
                    this.player.repeatRight = false;
                    break;
                }
                this.player.repeatLeft = true;
                break;
            }
            case 5: {
                if (this.player.repeatLeft) {
                    this.player.repeatLeft = false;
                    break;
                }
                this.player.repeatRight = true;
                break;
            }
            case 1: {
                if (this.player.repeatDown) {
                    this.player.repeatDown = false;
                    break;
                }
                this.player.repeatUp = true;
                break;
            }
            case 6: {
                if (this.player.repeatUp) {
                    this.player.repeatUp = false;
                    break;
                }
                this.player.repeatDown = true;
                break;
            }
        }
    }

    public void keyReleased(int n) {
        this.player.repeatLeft = false;
        this.player.repeatRight = false;
        this.player.repeatDown = false;
        this.player.repeatUp = false;
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isGameOver() {
        return this.isGameOver;
    }

    public void die() {
        if (Constants.lives > 0) {
            this.player.setFishcount((byte)0);
            this.player.breath = 0;
            attack.setActive(false);
            this.player.atSurface = true;
            Constants.lives = (byte)(Constants.lives - 1);
            this.init();
        } else {
            this.isGameOver = true;
        }
    }

    public static GameCanvas getInstance() {
        return instance;
    }

    public Diver getDiver() {
        return this.player;
    }

    public void drawAttack(Graphics graphics) {
        byte by = 0;
        while (by < attack.getMaxitems()) {
            Fish fish;
            Fish fish2 = attack.getShark(by);
            if (fish2.isVisible() && !fish2.isDead()) {
                graphics.drawImage(fish2.getImage(), fish2.getX(), fish2.getY(), 20);
            }
            if ((fish = attack.getFish(by)).isVisible() && !fish.isDead()) {
                graphics.drawImage(fish.getImage(), fish.getX(), fish.getY(), 20);
            }
            by = (byte)(by + 1);
        }
    }

    public void drawSub(Graphics graphics) {
        graphics.drawImage(this.player.getImage(), this.player.getX(), this.player.getY(), 20);
    }

    public void drawFires(Graphics graphics) {
        Fire fire = this.player.getFire();
        if (fire != null && fire.isVisible()) {
            graphics.drawImage(fire.getImage(), fire.getX(), fire.getY(), 2 | 1);
        }
    }

    public void drawBackground(Graphics graphics) {
        graphics.setColor(0, 80, 189);
        graphics.fillRect(0, SurfaceY, ScreenWidth, ScreenHeight);
        if (frame % 2 == 0) {
            wave_index = (byte)(wave_index + 1);
            wave_index = (byte)(wave_index % 4);
            if ((clouds_x -= 3) <= -Constants.img_clouds.getWidth()) {
                clouds_x = ScreenWidth;
                clouds_y = Math.abs(new Random().nextInt()) % (SurfaceY - Constants.img_clouds.getHeight());
            }
        }
        graphics.drawImage(Constants.img_clouds, clouds_x, clouds_y, 0x10 | 4);
        graphics.drawImage(Constants.img_wave[wave_index], 0, SurfaceY, 0x10 | 4);
        graphics.drawImage(Constants.img_wave[wave_index], Constants.img_wave[wave_index].getWidth(), SurfaceY, 0x10 | 4);
        graphics.drawImage(Constants.img_ground, 0, ScreenHeight - Constants.img_ground.getHeight(), 0x10 | 4);
        graphics.drawImage(Constants.img_ground, Constants.img_ground.getWidth(), ScreenHeight - Constants.img_ground.getHeight(), 0x10 | 4);
    }

    public void drawDetails(Graphics graphics) {
        int n;
        graphics.setFont(Constants.FONT);
        graphics.setColor(255, 255, 255);
        graphics.drawString(String.valueOf(Constants.score), ScreenWidth - 1, 3, 8 | 0x10);
        graphics.setColor(0, 0, 0);
        graphics.drawString(String.valueOf(Constants.score), ScreenWidth - 2, 2, 8 | 0x10);
        if (this.player.breath < 300) {
            graphics.setColor(255, 255, 255);
        } else {
            graphics.setColor(255, 255, 0);
        }
        graphics.fillRoundRect(2, 2, this.player.breath * (ScreenWidth * 60 / 100) / 1000, 5, 2, 2);
        graphics.setColor(0, 0, 0);
        graphics.drawRoundRect(2, 2, this.player.breath * (ScreenWidth * 60 / 100) / 1000, 5, 2, 2);
        if (this.player.getFishcount() == 6) {
            if (frame % 10 < 5) {
                n = 0;
                while (n < this.player.getFishcount()) {
                    graphics.drawImage(Constants.img_fish[0], 2 + n * (Constants.img_fish[0].getWidth() + 3), 10, 4 | 0x10);
                    ++n;
                }
            }
        } else {
            n = 0;
            while (n < this.player.getFishcount()) {
                graphics.drawImage(Constants.img_fish[0], 2 + n * (Constants.img_fish[0].getWidth() + 3), 10, 4 | 0x10);
                ++n;
            }
        }
        n = 0;
        while (n < Constants.lives) {
            graphics.drawImage(Constants.img_life, 2 + n * (Constants.img_life.getWidth() + 3), 18, 4 | 0x10);
            ++n;
        }
    }

    public void drawGameover(Graphics graphics) {
        this.removeCommand(Constants.pauseCommand);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(0, 0, ScreenWidth, ScreenHeight);
        short s = (short)(graphics.getClipWidth() / 2 - Constants.gameOverImg.getWidth() / 2);
        short s2 = (short)(graphics.getClipHeight() / 2 - Constants.gameOverImg.getHeight() / 2);
        graphics.drawImage(Constants.gameOverImg, (int)s, (int)s2, 20);
    }

    public void drawHiScore() {
        Form form = (Form)ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).getScreen(6);
        String string = Constants.TITLE_SCORE_STR;
        if (form.size() > 1) {
            form.delete(form.size() - 1);
        }
        form.append(string + " " + Integer.toString(Constants.score));
        ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(6);
    }

    public void commandAction(Command command, Displayable displayable) {
        ApplicationController applicationController = ApplicationController.getInstance(AbstractMIDlet.getAppClassName());
        Form form = (Form)applicationController.getScreen(2);
        if (displayable == form) {
            if (command == Constants.yesCommand) {
                this.isGameOver = true;
                applicationController.changeScreen(4);
            } else if (command == Constants.noCommand) {
                this.addCommand(Constants.pauseCommand);
                this.removeCommand(Constants.yesCommand);
                applicationController.changeScreen(1);
                this.isPaused = false;
            }
        } else if (displayable == applicationController.getScreen(6)) {
            String string = ((TextField)((Form)applicationController.getScreen(6)).get(0)).getString();
            SeaPersistence.getInstance().setScore(string, Constants.score);
            ((GameController)applicationController).writeHiScore();
            applicationController.getScreen(5).removeCommand(Constants.backCommand);
            applicationController.getScreen(5).removeCommand(Constants.emptyCommand);
            applicationController.getScreen(5).addCommand(Constants.okCommand);
            applicationController.getScreen(5).addCommand(Constants.emptyCommand);
            applicationController.changeScreen(5);
        } else if (displayable == applicationController.getScreen(5)) {
            if (command == Constants.okCommand) {
                applicationController.getScreen(5).removeCommand(Constants.okCommand);
                applicationController.getScreen(5).addCommand(Constants.backCommand);
                applicationController.changeScreen(4);
            } else if (command == Constants.backCommand) {
                applicationController.changeScreen(4);
            }
        } else if (command == Constants.exitCommand) {
            if (this.isPaused) {
                this.removeCommand(Constants.resumeCommand);
            }
            if (this.isGameOver) {
                if (SeaPersistence.getInstance().getScoreValue(SeaPersistence.getInstance().getScoreNumber() - 1) < Constants.score) {
                    this.drawHiScore = true;
                    this.repaint();
                    this.serviceRepaints();
                } else {
                    ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(4);
                }
            } else {
                ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(2);
            }
            this.isPaused = true;
        } else if (command == Constants.pauseCommand) {
            this.removeCommand(Constants.pauseCommand);
            this.addCommand(Constants.resumeCommand);
            this.isPaused = true;
        } else if (command == Constants.resumeCommand) {
            this.removeCommand(Constants.resumeCommand);
            this.addCommand(Constants.pauseCommand);
            this.isPaused = false;
        } else if (command == Constants.okCommand) {
            ApplicationController.getInstance(AbstractMIDlet.getAppClassName()).changeScreen(4);
        }
    }

    static {
        level = 1;
    }
}

